/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.io;

import java.io.*;

/**
 * Output stream that ignores all data written. Similar to /dev/null. Typical
 * application is when data sink must be specified even though the application
 * does not care for the data and wants it discarded.
 * For instance, assigning this to {@link System#setOut} suppresses standard
 * output.
 *
 * @author Dawid Kurzyniec
 * @version 1.0
 */
public class NullOutputStream extends OutputStream {
    /** Creates a new NullOutputStream. */
    public NullOutputStream() {}
    /** Does nothing. */
    public void write(byte[] buf, int off, int len) {}
    /** Does nothing. */
    public void write(int b) {}
    /** Does nothing. */
    public void flush() {}
    /** Does nothing. */
    public void close() {}
}
